IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_CLI_CONV_PBM_CONTROLE_CENTRALIZADO_CPL]') 
					AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [DBO].[P_RC_CLI_CONV_PBM_CONTROLE_CENTRALIZADO_CPL]
END
GO
--P_RC_CLI_CONV_PBM_CONTROLE_CENTRALIZADO_CPL 0,36263,54
 CREATE PROCEDURE P_RC_CLI_CONV_PBM_CONTROLE_CENTRALIZADO_CPL (@CD_CTR_CENTRALIZADO INT,@CD_PROD INT, @QT_PROC MONEY, @NR_NF INT=0,@CD_FILIAL_DEPOSITO INT=0, @CD_EMP_PAR INT=1)
 AS
SET NOCOUNT ON; 
Create table #RsVendasItPBM(CD_EMP INT,
							CD_FILIAL INT,
							CD_PROD INT,
							QT_IT MONEY,
							PERC_PART MONEY,
							QT_IT_BAIXA MONEY,
							QT_SALDO MONEY)

DECLARE @QT_VD_TOTAL FLOAT
DECLARE @PERC_PART FLOAT
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @QT_SALDO MONEY
DECLARE @QT_FILIAL MONEY
DECLARE @CD_CTR_AJUSTES INT

INSERT INTO #RsVendasItPBM
SELECT
	PDV_VD_IT.CD_EMP,
	PDV_VD_IT.CD_FILIAL,
	PDV_VD_IT.CD_PROD,
	SUM(PDV_VD_IT.QT_IT),
	0,
	0,
	0 AS QT_SALDO
FROM
	PDV_VD_IT_VD_PBM INNER JOIN PDV_VD_IT ON
	PDV_VD_IT_VD_PBM.CD_EMP = PDV_VD_IT.CD_EMP AND
	PDV_VD_IT_VD_PBM.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
	PDV_VD_IT_VD_PBM.CD_VD = PDV_VD_IT.CD_VD AND
	PDV_VD_IT_VD_PBM.CD_IT = PDV_VD_IT.CD_IT  
	INNER JOIN RC_CLI_CONV_PBM_CONTROLE_EST_PROD ON
	PDV_VD_IT.CD_EMP = RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_EMP AND
	PDV_VD_IT.CD_FILIAL = RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_FILIAL AND
	PDV_VD_IT.CD_PROD = RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_PROD 
WHERE
	PDV_VD_IT.CD_EMP=@CD_EMP_PAR
	AND PDV_VD_IT.DT_VD>=GETDATE()-90
	AND PDV_VD_IT.ST_IT=1
	AND PDV_VD_IT.CD_PROD=@CD_PROD
GROUP BY
	PDV_VD_IT.CD_EMP,
	PDV_VD_IT.CD_FILIAL,
	PDV_VD_IT.CD_PROD

SET @QT_VD_TOTAL = ISNULL((SELECT
						SUM(QT_IT)
					FROM
						#RsVendasItPBM),0)

SET @QT_SALDO=@QT_PROC

UPDATE
	#RsVendasItPBM
SET
	PERC_PART =(QT_IT / @QT_VD_TOTAL) * 100.00

DECLARE ProcPBMDist CURSOR FAST_FORWARD
FOR SELECT
		CD_EMP,
		CD_FILIAL
	FROM
		#RsVendasItPBM
	ORDER BY
		PERC_PART DESC

OPEN ProcPBMDist;
FETCH NEXT FROM ProcPBMDist INTO @CD_EMP,
								 @CD_FILIAL;
WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT 'Filial '+CONVERT(VARCHAR(10), @CD_FILIAL)+' '+CONVERT(VARCHAR, GETDATE(), 108);
		IF @QT_SALDO > 0 
		BEGIN
			UPDATE
				#RsVendasItPBM
			SET
				QT_SALDO=@QT_SALDO,
				@QT_FILIAL=CEILING(@QT_PROC * (PERC_PART/ 100.00)),
				QT_IT_BAIXA =CASE WHEN  
								@QT_SALDO >= @QT_FILIAL 
							THEN 
								@QT_FILIAL 
							ELSE 
								@QT_SALDO 
							END
				WHERE
					CD_EMP=@CD_EMP
					AND CD_FILIAL=@CD_FILIAL
				
				SET @QT_SALDO= @QT_SALDO-@QT_FILIAL
			END	
		ELSE
			BEGIN
				SET @QT_FILIAL=0
			END
		FETCH NEXT FROM ProcPBMDist INTO @CD_EMP
											, @CD_FILIAL;
	END;
PRINT 'Concluido.';
CLOSE ProcPBMDist;
DEALLOCATE ProcPBMDist;

IF @CD_CTR_CENTRALIZADO=0 
BEGIN
	SELECT
		*
	FROM
		#RsVendasItPBM
	ORDER BY
		PERC_PART DESC
END						
ELSE
BEGIN
	
DECLARE ProcPBMDist CURSOR FAST_FORWARD
FOR SELECT
		CD_EMP,
		CD_FILIAL
	FROM
		#RsVendasItPBM
	WHERE
		QT_IT_BAIXA > 0

OPEN ProcPBMDist;
FETCH NEXT FROM ProcPBMDist INTO @CD_EMP,
								 @CD_FILIAL;
WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @CD_CTR_AJUSTES=0
		INSERT INTO RC_CLI_CONV_PBM_CONTROLE_AJUSTES
		(CD_EMP,
		CD_PROD,
		DT_MOVIMENTO,
		DT_CAD,
		CD_USU,
		HISTORICO,
		QT_MOVIMENTO,
		TP_TRANSACAO,
		CD_FILIAL,
		ORIGEM_TRANSACAO)
		SELECT
			CD_EMP,
			CD_PROD,
			CONVERT(CHAR(10),GETDATE(),112),
			GETDATE(),
			1,
			'REPOSICAO PBM CENTRALIZADA FILIAL ' + CONVERT(VARCHAR(10),@CD_FILIAL_DEPOSITO) + ' NOTA FISCAL ' + CONVERT(VARCHAR(20),@NR_NF) ,
			QT_IT_BAIXA,
			0,
			CD_FILIAL,
			1
		FROM
			#RsVendasItPBM
		WHERE
			CD_EMP =@CD_EMP 
			AND CD_FILIAL=@CD_FILIAL

		SET @CD_CTR_AJUSTES=SCOPE_IDENTITY()	
				
		INSERT INTO RC_CLI_CONV_PBM_CENTRALIZADO_CPL
		(CD_CTR_CENTRALIZADO,
		CD_CTR_AJUSTES)
		SELECT
			@CD_CTR_CENTRALIZADO,
			@CD_CTR_AJUSTES
		
		FETCH NEXT FROM ProcPBMDist INTO @CD_EMP
											, @CD_FILIAL;
	END;
PRINT 'Concluido.';
CLOSE ProcPBMDist;
DEALLOCATE ProcPBMDist;
END
DROP TABLE #RsVendasItPBM